#!/bin/sh

################################################
###### Powered by ooolexa (GiClub Team)  ######
######       http://www.giclub.tv         ######
################################################
CAMNAME="WiCard 1.19"


remove_tmp () {
	rm -rf /tmp/cainfo.* /tmp/camd.* /tmp/sc.* /tmp/*.info* /tmp/*.tmp* /tmp/oscam*
	[ -e /tmp/.oscam ] && rm -rf /tmp/.oscam
	[ -e /tmp/.emu.info ] && rm -rf /tmp/.emu.info
	[ -e /tmp/oscam.mem ] && rm -rf /tmp/oscam.mem
}

case "$1" in
start)
    echo "[SCRIPT] $1: $CAMNAME"
		remove_tmp
		touch /tmp/.emu.info
		echo "WiCard 1.19" > /tmp/.emu.info
    ulimit -s 512
    exec start-stop-daemon -S -x /usr/bin/wicardd-armv7a-eabihf -- -d -c /etc/tuxbox/config/wicardd.conf
    ;;
stop)
    exec start-stop-daemon -K -R 2 -x /usr/bin/wicardd-armv7a-eabihf &
    sleep 2
    killall -9 wicardd-armv7a-eabihf 2>/dev/null
    sleep 2
    rm -rf /tmp/.wicardd
    ;;
restart|reload)
    $0 stop
    sleep 1
    $0 start
    ;;
version)
    echo "1.19"
    ;;
info)
    echo "wicardd 1.19"
    ;;
*)
    echo "Usage: $0 start|stop|restart"
    exit 1
    ;;
esac
exit 0
